﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace Hex_Monitor
{
    public partial class Form1 : Form
    {
        bool open = false;

        public Form1()
        {
            InitializeComponent();
            ArrayList portdata = new ArrayList();
            //配列portdataを一時的に作成します。
            portdata.Add("");
            portdata.AddRange(System.IO.Ports.SerialPort.GetPortNames());
            //Addは一つ、AddRangeは複数追加します。
            //初期化し、ポート情報読み込み関数の返却値を代入。
            comboBox1.DataSource = portdata;
            //PortListコンポーネントがportdataを参照するようにする。

        }
        /// 
        /// テキストボックスにHEX表示を行う
        /// 
        /// 表示するデータ
        /// 一行の長さの計算
        /// 行の番号--5文字、データの長さ 3 x 16 = 48文字、改行--2文字　合計55文字
        private void addTextHex(int ivalue)
        {
            //数値データを大文字２文字のHEXデータに変換する
            string strData = Convert.ToString(ivalue, 16).ToUpper();

            //２文字の長さにあわせる、一文字の場合は0Aの様に０を加える
            strData = strData.PadLeft(2, '0') + " ";

            //テキストボックスに追加
            textBox1.AppendText(strData);

            //一行の長さが53文字になったら改行を加え
            //行の先頭に行番号を加える
            if (textBox1.Text.Length % 55 == 53)
            {
                //改行を加える
                textBox1.AppendText(Environment.NewLine);

                //**行の先頭に行番号を加える***
                //行番号の計算　一行は55文字であるから
                int intRno = textBox1.Text.Length / 55 + 1;
                //行番号をHEXに直す
                string strRno = Convert.ToString(intRno, 16).ToUpper();

                //行の番号を４桁に揃え、行番号の最後に「:」を加える
                strRno = strRno.PadLeft(4, '0') + ":";
                //テキストボックスに追加する
                textBox1.AppendText(strRno);
            }
        }

        //引数にIntegerを持つデリゲートを宣言する
        public delegate void myDelegate(int intdata);
        /// 
        /// serialPort1のDataReceivedイベント
        /// 
        /// 
        /// 
        private void serialPort1_DataReceived(object sender,
                              System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            //メインスレッドのtextBox1にデリゲートを使って書き込む
            //デリゲートのインスタンスを作成して、addTextHexの参照を設定する
            myDelegate dlgByte = new myDelegate(addTextHex);

            //読み取るバイトバッファを設定
            byte[] byteRead = new byte[serialPort1.BytesToRead];

            //データを読み取る
            serialPort1.Read(byteRead, 0, serialPort1.BytesToRead);

            //デリゲートを使って書き込む
            for (int i = 0; i < byteRead.Length; i++)
                this.Invoke(dlgByte, (Int32)byteRead[i]);

        }

        //テキストボックスをクリアします
        private void button1_Click(object sender, EventArgs e)
        {
            if (!open)
            {
                comboBox1.Enabled = false;
                button1.Text = "Close(&1)";
                serialPort1.PortName = comboBox1.Text;
                serialPort1.Open();
                open = true;
            }
            else
            {
                serialPort1.Close();
                open = false;
                comboBox1.Enabled = true;
                button1.Text = "Open(&1)";
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.Text != "")
                button1.Enabled = true;
            else
                button1.Enabled = false;
            //未選択状態でのポートオープン防止
        }

        private void button2_Click(object sender, EventArgs e)
        {
            textBox1.Text = "0001:"; 
        }
    }
}
